/**
 * \file: grl_dlt_log.h
 *
 * \version: $Id: grl_dlt_log.h,v 0.1 2015/05/20 11:54:54 $
 *
 * \component:  Dlt support for svg component
 *
 * \author:Anil.V
 *
 * \copyright: (c) 2003 - 2004 ADIT Corporation
 *
 * \history
 *
 ***********************************************************************/

#ifndef _SVG_DLT_ERROR_
#define _SVG_DLT_ERROR_

#include "svg_typedef.h"
#include <stdarg.h>
#include <ctype.h>
#include <string.h>

/* Macros for svg specific debug levels */
#define	SVG_LOG_FATAL     		1 	/* fatal system error */
#define	SVG_LOG_ERROR     		2 	/* error with impact to correct functionality */
#define	SVG_LOG_WARN      		3 	/* warning, correct behaviour could not be ensured */
#define	SVG_LOG_INFO      		4 	/* informational */
#define	SVG_LOG_DEBUG     		5 	/* debug  */
#define	SVG_LOG_VERBOSE    		6 	/* debug  */

#define DLT_SERVICE_LOGLVL_SFNT		0xFFF1   /* service ID for svg_font */
#define DLT_SERVICE_LOGLVL_SBMP		0xFFF2   /* service ID for svg_bmp */
#define DLT_SERVICE_LOGLVL_SCOM		0xFFF3   /* service ID for svg_common */

#define UNUSED_ARG(arg) arg=arg;

/* Dlt specific variables for ctx and debug level */
extern SVGUint8 grl_scom_debugLevel;
extern void *grl_scom_dlt_ctx;

/*
* Use util macros for trace.
* For an explanation of the macros usage please refer to util_lib.h.
*
* The used trace level depends on the developer. In general following criteria can be used:
* Fatal:    When the system can not work any longer
* Error:    Error in function occur which leeds to a not expected result
* Warning:  Function can still work as expected but some limitation may happen
*           (e.g. default value has to be used instead of intended devconf value)
* User:     Just information should be traced out.
*
*/
#define SVG_DLT_F(ctx, debugLevel, args...) svg_print(ctx,debugLevel, SVG_LOG_FATAL, args)
#define SVG_DLT_E(ctx, debugLevel, args...) svg_print(ctx,debugLevel, SVG_LOG_ERROR, args)
#define SVG_DLT_W(ctx, debugLevel, args...) svg_print(ctx,debugLevel, SVG_LOG_WARN, args)
#define SVG_DLT_U(ctx, debugLevel, args...) svg_print(ctx,debugLevel, SVG_LOG_INFO, args)
#define SVG_DLT_D(ctx, debugLevel, args...) svg_print(ctx,debugLevel, SVG_LOG_DEBUG, args)


/* Macros exported to svg common for dlt tracing */
#define SVG_COM_F(args...) svg_print_com(grl_scom_dlt_ctx, grl_scom_debugLevel, SVG_LOG_FATAL, args)
#define SVG_COM_E(args...) svg_print_com(grl_scom_dlt_ctx, grl_scom_debugLevel, SVG_LOG_ERROR, args)
#define SVG_COM_W(args...) svg_print_com(grl_scom_dlt_ctx, grl_scom_debugLevel, SVG_LOG_WARN, args)
#define SVG_COM_U(args...) svg_print_com(grl_scom_dlt_ctx, grl_scom_debugLevel, SVG_LOG_INFO, args)
#define SVG_COM_D(args...) svg_print_com(grl_scom_dlt_ctx, grl_scom_debugLevel, SVG_LOG_DEBUG, args)


/************************** DLT Function declaration *****************************/

typedef SVGInt32 (*svgDltLogLevelInjection) (SVGUint32 service_id, void * data, SVGUint32 length) ;

void *svg_init_dlt( SVGChar *name, SVGChar *dscip ,SVGUint32 serviceID,
		svgDltLogLevelInjection fnptr_svg_dltinjection);

void svg_print(void * ctx , SVGUint8 debug_level, SVGUint8 level, SVGChar* msg,...);

void svg_print_com(void * ctx ,SVGUint8 debug_level ,SVGUint8 level, SVGChar* msg,...);

void svg_de_init_dlt( void * ctx );

/*
 * Define function Number
 */
typedef enum {
    /* functions of svg_font */
    /* grl_font.h */
    GRL_REDUCE_CACHABLE_GLYPHS = 0x0e,
    GRL_CACHE_CLEANUP_NEEDED,
    GRL_BUILDUP_FONT_DATABASE,
    GRL_UPDATE_FONTS,
    GRL_GET_FONT_ID,
    GRL_BUILDUP_FLASH_FONT_DATABASE,
    GRL_BUILDUP_FILE_FONT_DATABASE,
    GRL_GET_NEXT_MODULE_INFO,
    GRL_NUM_OF_FLASH_FONT,
    GRL_IS_VALID_SUFFIX,
    GRL_GET_FLASH_FONT_FILE,
    GRL_BUILD_FILE_FONT_LIST,
    GRL_CREATE_FONT_MODULE,
    GRL_DESTROY_FONT_MODULES,
    GRL_DESTROY_FONT_MODULE_POINTER,
    GRLXXCREATEFONTCONTEXT,
    GRLXXDESTROYFONTCONTEXT,
    GRLXXLOADFONT,
    GRLXXENABLEFONTSETTINGS,
    GRLXXDISABLEFONTSETTINGS,
    GRLXXISFONTSETTINGENABLED,
    GRLXXGETFONTBITMAP,
    GRLXXGETFONTBITMAPEXT,
    GRLXXFREEFONTBITMAPMEM,
    GRLXXDRAWFONTWITHCURSORINFO,
    GRLXXGETFONTBBOX,
    GRLXX_GET_FONT_SUFFIX,
    GRLXX_FILL_FONT_STRUCT,
    GRLXXGETFONTMAXCHARS,
    GRLXXGETFONTINFORMATION,
    GRLXXSETFONTSIZE,
    GRLXXDUMPFONTWALLPAPER,
    GRLXX_GET_CHARINDEXLIST,
    GRLXXENABLESHAPINGENGINE,
    GRLXXDISABLEHAPINGENGINE,
    /* svg_font.h */
    SVGINITFONTS,
    SVGCLOSEFONTS,
    SVGUPDATEFONTS,
    SVGGETAVAILABLEFONTMODULES,
    SVGCREATEFONTCONTEXT,
    SVGDESTROYFONTCONTEXT,
    SVGGETUSEDFONTMODULE,
    SVGGETFONTERROR,
    SVGGETAVAILABLEFONTS,
    SVGLOADFONT,
    SVGSETFONTROTATE,
    SVGGETFONTROTATE,
    SVGENABLEFONTSETTINGS,
    SVGDISABLEFONTSETTINGS,
    SVGISFONTSETTINGENABLED,
    SVGSETFONTLETTERDISTANCE,
    SVGGETFONTLETTERDISTANCE,
    SVGGETFONTBBOX,
    SVGGETFONTLINESPACING,
    SVGSETFONTDRAWINGORIGIN,
    SVGGETFONTDRAWINGORIGIN,
    SVGGETFONTBITMAP,
    SVGFREEFONTBITMAPMEM,
    SVGDRAWFONTSTRING,
    SVGDRAWFONTWITHCURSORINFO,
    SVGGETFONTMAXCHARS,
    SVGGETFONTGLYPHCOUNT,
    SVGGETFONTINFORMATION,
    SVGSETFONTOPACITY,
    SVGGETFONTOPACITY,
    LOCAL_BUILD_FILE_FONT_LIST,
    SVGDRAWFONTSTRINGEXT,
    SVGSETFONTSIZE,
    SVGSETFONTSCALE,
    SVGGETFONTSCALE,
    SVGSETFONTREPLACEMENTCHAR,
    SVGGETFONTREPLACEMENTCHAR,
    LOCAL_GET_BITMAP,
    SVGGETCONTOURCOLOR,
    SVGSETCONTOURCOLOR,
    SVGGETFONTBITMAPEXT,
    SVGSETCONTOURWIDTH,
    SVGGETCONTOURWIDTH,
    SVGSETBODYCOLOR,
    SVGGETBODYCOLOR,
    GRL_GET_BITMAP,
    SVGDUMPFONTWALLPAPER,
    CHECK_SHMEMORY,
    CREATE_SHMEMORY,
    X86_GRL_FONT_ENTER,
    X86_GRL_FONT_EXIT,
    SVGSETCACHABLEGLYPHCOUNT,
    GRLXXSETCACHABLEGLYPHCOUNT,
    LOCAL_DRAWFONTWITHCURSORINFO
} SVG_FUNCTION_FONT;
#endif /* _SVG_DLT_ERROR_ */
